# Views Integration

The graphql_core_schema module includes
a [submodule with Views integration](https://graphql-core-schema.netlify.app/schema-extensions/views.html) that allows
you to expose Views as GraphQL queries.

**Hint**
::alert{type="danger"}
After enabling the extension and saving the server form a new subform appears where you can select which views should be
enabled. By default, no view is enabled, and it's not possible to execute any view.
::

## Example query
    
```graphql
query {
  entityById(entityType: VIEW, id: "media") {
    ... on View {
      executable {
        ... on ViewExecutableMediaDefault {
          execute(name: "test", sortBy: "created") {
            rows {
              ... on Media {
                label
              }
            }
          }
        }
      }
    }
  }
}
```

