# paragraphs_blokkli module

The [paragraphs_blokkli](https://www.drupal.org/project/paragraphs_blokkli) module provides a set of configuration
options, that can be used to integrate some advanced features of blökkli namely the media library, clipboard
integration and the search.

## Schema Mapping

The module provides a settings form under `/admin/config/content/blokkli` where you can configure
the path of the `schema.json` file generated by the frontend. blökkli provides a
[customizable options](/frontend/blokkli#defining-component-options) on every
component. These options are store in Drupal as paragraph behaviours. The schema.json file helps Drupal, to
automatically build an appropriated form for the content editor.
The main goal is, that everything done in blökkli can also be done in Drupal.

**blokkli Options**
![blokkli_options.png](/content/images/blokkli_options.png){width=600px}

**Corresponding Drupal paragraphs behvaiour**
![behaviours.png](/content/images/behaviours.png){width=600px}

### Clipboard Mapping

blökkli has a clipboard feature, that allows to copy and paste an image or a YouTube video url into the editor.
It will automatically open the clipboard panel and allows you to drag the element into the editor.

Inside the mapping you can define, what paragraph should automatically be created, when a specific element is pasted.
![behaviours.png](/content/images/clipboard.png){width=600px}

## Entity Mapping

This configuration defines how certain entities such as media (images, videos) or nodes should be mapped to paragraphs
when users drag and drop existing entities (from the media library or search) or from their computer (images, files).

## Search

blökkli provides a search feature, that allows you to search for media, nodes or other entities from the editor.
The search is can be powered by the Drupal search API or by a normal entity query.
![media_library.png](/content/images/media_library.png){width=300px}

It has a plugin based architecture, that allows you to extend the search with custom plugins.
We recommend you to create use a Search API based index on Elasticsearch or Solr for better performance.

![search_api_mapping.png](/content/images/search_api_mapping.png)
