# Nuxt Eco-System

To provide an awesome developer experience, we created and maintain a set of Nuxt modules, that will make your life
easier when working with a decoupled Drupal backend.

## Overview of our Nuxt Modules

This page provides an overview of the related modules and what they do for you.

### [Nuxt GraphQL Middleware](https://nuxt-graphql-middleware.dulnan.net/)

This module exposes GraphQL queries and mutations as fully typed API endpoints. It hides your GraphQL server from
public access and prevents bundling large queries.

To understand the concept of the GraphQL middleware, please check the [Architecture](/introduction/architecture) page.

### [Nuxt Multi Cache](https://nuxt-multi-cache.dulnan.net/)

This module provides a cache layer for your data, components and routes. It dynamically defines CDN cache control
headers and provides a cache management API that can be connected with the well-known
[Purge](https://www.drupal.org/project/purge) module of Drupal.
In the blökkli starterkit, this is already wired up for your convenience.

### [Nuxt Language Negotiation](https://github.com/dulnan/nuxt-language-negotiation)

This module provides basic multi-language support for a Nuxt application with Drupal in mind.
For more information, please check the [Multilangue Setup](/drupal/multilanguage) page.

### [Nuxt Easy Texts](https://nuxt-easy-texts.dulnan.net/)

This module is a drop-in replacement of the famous Drupal t function. It provides a simple way to manage
translations in your Vue components. It extracts strings and sends them to the Drupal backend to make them editable by
editors.
For more information, please check the [Multilangue Setup](/drupal/multilanguage) page.

### [Nuxt Rokka Image](https://github.com/rokka-io/nuxt-module)

Please check the documentation about [image handling](/introduction/images) for more information.

### [Nuxt SVG Icon Sprite](https://github.com/dulnan/nuxt-svg-icon-sprite)

Please check the documentation about [icon handling](/introduction/icons) for more information.

### VuePal

This module provides a bridge between Drupal and Vue. It allows you to display an admin toolbar and an environment
indicator in your Nuxt application. It also provides an easy way to fetch Drupal route data and metatags in your
application.

It also comes with a LocalTasks component to display the local tasks of a Drupal page.

### [blökkli](https://blokk.li/)

This module provides the in-page editing experience for Drupal. It allows you to edit paragraphs in a new way.

Please check the documentation about [blökkli](/frontend/blokkli) for more information.

## Recommended other Nuxt Modules

We recommend the following Nuxt modules to make your life easier:

### [@nuxt/eslint](https://eslint.nuxt.com/packages/module) module

Make sure your code is clean and follows the best practices.

### [@nuxtjs/tailwindcss](https://tailwindcss.nuxtjs.org/) module

You love it or hate it. Tailwind is a great CSS framework to speed up your frontend development.

### [vitest](https://vitest.dev/)

A testing framework for Vue.js applications. It provides a simple way to write tests for your Vue components.
