import drupal from '@blokkli/editor/drupal'
import { defineNuxtConfigProperty } from '.'

export default defineNuxtConfigProperty<'blokkli'>((ctx) => {
  return {
    modules: [drupal()],
    globalOptions: {
      teaserStyle: {
        type: 'radios',
        label: 'Display',
        default: 'grid',
        options: {
          grid: 'Grid',
          staggered_grid: 'Staggered Grid',
        },
      },
      mobileStyle: {
        type: 'radios',
        label: 'Mobile display',
        default: 'stapel',
        options: {
          stack: 'Stack',
          slider: 'Slider',
        },
      },
      spacing: {
        type: 'radios',
        label: 'Spacing',
        default: 'none',
        displayAs: 'icons',
        options: {
          none: { label: 'no spacing', icon: 'icon-blokkli-option-no-spacing' },
          small: {
            label: 'small spacing',
            icon: 'icon-blokkli-option-small-spacing',
          },
          large: {
            label: 'large spacing',
            icon: 'icon-blokkli-option-large-spacing',
          },
        },
      },
      imageFormat: {
        type: 'radios',
        label: 'Image Format',
        default: 'full',
        displayAs: 'icons',
        options: {
          full: { label: 'extra large', icon: 'icon-blokkli-option-xlarge' },
          big: { label: 'large', icon: 'icon-blokkli-option-large' },
          text: { label: 'medium', icon: 'icon-blokkli-option-medium' },
          small: { label: 'small', icon: 'icon-blokkli-option-small' },
        },
      },
    },
    translations: {
      en: {
        editIndicatorLabel: 'Edit paragraphs',
      },
      de: {
        editIndicatorLabel: 'Abschnitte bearbeiten',
      },
    },
    chunkNames: ['global', 'rare'],
    storageDefaults: {
      blockFavorites: ['text'],
    },
    schemaOptionsPath: ctx.DEV
      ? '../../drupal/docroot/modules/custom/blokkli_starterkit/data/schema.json'
      : undefined,
    defaultLanguage: 'de',
    // Make sure the editor is always rendered in German instead of the
    // current page language.
    forceDefaultLanguage: true,
  }
})
