import { defineNuxtConfigProperty } from '.'

export default defineNuxtConfigProperty<'graphqlMiddleware'>((ctx) => {
  return {
    serverApiPrefix: '/api/graphql',
    autoImportPatterns: [
      'pages/**/*.{gql,graphql}',
      'components/**/*.{gql,graphql}',
      'composables/**/*.{gql,graphql}',
      'app/**/*.{gql,graphql}',
      'helpers/**/*.{gql,graphql}',
      'graphql/**/*.{gql,graphql}',
      'stores/**/*.{gql,graphql}',
      'server/**/*.{gql,graphql}',
      'sites/**/*.{gql,graphql}',
      'layers/**/*.{gql,graphql}',
      '!node_modules',
    ],
    clientCache: {
      enabled: true,
      maxSize: 100,
    },
    documents: [],
    outputDocuments: true,
    downloadSchema: ctx.DEV,
    graphqlEndpoint: `${ctx.NUXT_BACKEND_URL}/graphql`, // If we have Multisite Setup we need to use NUXT_HOST here.
    graphqlConfigFilePath: '../graphql.config.ts',
    codegenConfig: {
      output: {
        nullableArrayElements: false,
      },
    },
    codegenSchemaConfig: {
      urlSchemaOptions: {
        headers: {
          'x-drupal-graphql-token': process.env.DRUPAL_GRAPHQL_TOKEN ?? '',
          'accept-language': 'en',
        },
      },
    },
  }
})
