import type { NuxtConfig } from '@nuxt/schema'

type ModuleConfigContext = {
  DEV: boolean
  NUXT_BACKEND_URL: string
  NUXT_REQUEST_HOST: string
  LANGCODES: string[]
}

const LANGCODES = ['de', 'fr', 'en']

const ctx: ModuleConfigContext = Object.freeze({
  DEV: process.env.NODE_ENV === 'development',
  NUXT_BACKEND_URL: process.env.NUXT_BACKEND_URL || '',
  NUXT_REQUEST_HOST: process.env.NUXT_REQUEST_HOST || '',
  LANGCODES,
})

export function defineNuxtConfigProperty<T extends keyof NuxtConfig>(
  cb: (ctx: ModuleConfigContext) => NuxtConfig[T],
) {
  return cb(ctx)
}
