import { defineNuxtConfigProperty } from '.'
import {
  pathPrefix,
  query,
  acceptLanguage,
} from 'nuxt-language-negotiation/negotiators'

export default defineNuxtConfigProperty<'languageNegotiation'>((ctx) => {
  return {
    // Define the available languages.
    languages: ctx.LANGCODES,

    // We use two negotiators: Path prefix takes precedence. In cases where no
    // path prefix is available, we fall back to Accept-Language headers.
    negotiators: [
      pathPrefix(),
      query({ keys: ['language', 'langcode'] }),
      acceptLanguage(),
    ],
    debug: false,
  }
})
