import { defineNuxtConfigProperty } from '.'

export default defineNuxtConfigProperty<'multiCache'>((ctx) => {
  return {
    component: {
      enabled: false,
    },
    data: {
      enabled: true,
    },
    route: {
      enabled: false,
    },
    api: {
      enabled: true,
      authorization: 'overriden-at-runtime',
      prefix: '/api/multi-cache',
      cacheTagInvalidationDelay: 5000,
    },
    cdn: {
      enabled: true,
      cacheControlHeader: 'CDN-Cache-Control',
      cacheTagHeader: 'Cache-Tag',
    },
    debug: ctx.DEV,
  }
})
