import { defineNuxtConfigProperty } from '.'

const ONE_YEAR = 31_536_000

export default defineNuxtConfigProperty<'routeRules'>(() => {
  return {
    '/de/error': {
      noScripts: true,
      prerender: true,
    },
    '/_nuxt/**': {
      cache: {
        maxAge: ONE_YEAR,
      },
      headers: {
        'cache-control': `public,max-age=${ONE_YEAR},s-maxage=${ONE_YEAR}`,
      },
    },
    '/fonts/**': {
      cache: {
        maxAge: ONE_YEAR,
      },
      headers: {
        'cache-control': `public,max-age=${ONE_YEAR},s-maxage=${ONE_YEAR}`,
      },
    },
  }
})
