import { defineNuxtConfigProperty } from '.'

export default defineNuxtConfigProperty<'vuepal'>((ctx) => {
  return {
    frontendRouting: {
      enabled: true,
      defaultLanguage: ctx.LANGCODES[0]!,
      outputPath: './../drupal/config/default/frontend_routing.settings.yml',
    },
    adminToolbar: {
      enabled: true,
    },
    localTasks: {
      enabled: true,
    },
    breadcrumb: {
      enabled: true,
    },
    languageSwitchLinks: {
      enabled: true,
    },
    drupalRoute: {
      enabled: true,
      // The route queries that will be generated for useDrupalRouteQuery().
      routeQueries: {
        slug: { fragments: ['nodePage'] },
        nodeContact: { fragments: ['nodeContact'] },
        nodePage: { fragments: ['nodePage'] },
        nodePressRelease: { fragments: ['nodePressRelease'] },
        nodeCanonical: {
          fragments: ['nodeContact', 'nodePage', 'nodePressRelease'],
        },
      },
    },
    trustedOrigins: {
      enabled: false,
      origins: ['https://starterkit.ddev.site'],
    },
    devMode: {
      enabled: true,
      url: `https://${ctx.NUXT_REQUEST_HOST}`,
      forceHttps: true,
    },
  }
})
