import type { GraphqlResponseTyped } from '#nuxt-graphql-middleware/response'
import type { H3Event } from 'h3'

export function useGraphqlCacheability(
  event: H3Event,
  response?: GraphqlResponseTyped,
) {
  if (import.meta.server) {
    useCDNHeaders((cdn) => {
      const cacheability = response?.extensions.cacheability
      if (!cacheability?.isCacheable) {
        cdn.private()
        return
      }

      cdn
        .public()
        .setNumeric('maxAge', cacheability.maxAge)
        .addTags(cacheability.tagsCdn)
    }, event)
  }
}
