import type { InitData, MappedMenuLink } from '~/plugins/initData'

export type UseInitData = {
  globalConfig: ComputedRef<InitData['globalConfig']>
  mainMenuLinks: ComputedRef<MappedMenuLink[]>
  footerMenuLinks: ComputedRef<MappedMenuLink[]>
  footerSocialMediaLinks: ComputedRef<MappedMenuLink[]>
}

export default function (): UseInitData {
  const data = useState<InitData | null>('initData', () => null)

  return {
    globalConfig: computed(() => data.value?.globalConfig || {}),
    mainMenuLinks: computed(() => data.value?.mainMenuLinks || []),
    footerMenuLinks: computed(() => data.value?.footerMenuLinks || []),
    footerSocialMediaLinks: computed(
      () => data.value?.footerSocialMediaLinks || [],
    ),
  }
}
