import { defineGraphqlClientOptions } from 'nuxt-graphql-middleware/client-options'

export default defineGraphqlClientOptions<{
  language: string
  hash: string
  env?: 'server'
}>({
  buildClientContext() {
    const language = useCurrentLanguage()
    const config = useRuntimeConfig()

    return {
      language: language.value,
      hash: config.public.buildHash,
      env: import.meta.server ? 'server' : undefined,
    }
  },
})
