import blokkli from './.config/blokkli'
import easyTexts from './.config/easyTexts'
import graphqlMiddleware from './.config/graphqlMiddleware'
import languageNegotiation from './.config/languageNegotiation'
import multiCache from './.config/multiCache'
import nitro from './.config/nitro'
import rokka from './.config/rokka'
import routeRules from './.config/routeRules'
import runtimeConfig from './.config/runtimeConfig'
import svgIconSprite from './.config/svgIconSprite'
import vuepal from './.config/vuepal'

const IS_DEV = process.env.NODE_ENV === 'development'

export default defineNuxtConfig({
  blokkli,
  devtools: { enabled: true },
  easyTexts,
  future: { compatibilityVersion: 4 },
  graphqlMiddleware,
  languageNegotiation,
  multiCache,
  pageDependencies: { checkComposableCalled: true },
  rokka,
  routeRules,
  runtimeConfig,
  svgIconSprite,
  telemetry: false,
  vuepal,
  nitro,
  watch: ['build'],

  app: {
    rootId: 'nuxt-root',
    pageTransition: { name: 'page', mode: 'out-in' },
    head: {
      title: 'Starterkit',
      htmlAttrs: {
        tagDuplicateStrategy: 'merge',
        lang: 'de',
      },
    },
  },

  modules: [
    'nuxt-easy-texts',
    'nuxt-graphql-middleware',
    'vuepal',
    '@nuxt/test-utils/module',
    '@nuxtjs/tailwindcss',
    'nuxt-language-negotiation',
    '@rokka-io/nuxt',
    'nuxt-page-dependencies',
    'nuxt-multi-cache',
    '@formkit/nuxt',
    'nuxt-svg-icon-sprite',
    '@blokkli/editor',
    '@nuxt/eslint',
  ],

  tailwindcss: {
    cssPath: ['~/assets/css/tailwind.css', { injectPosition: 'first' }],
  },

  sourcemap: {
    server: IS_DEV,
    client: IS_DEV,
  },

  vite: {
    css: {
      devSourcemap: true,
    },
    server: {
      allowedHosts: true,
    },
  },

  typescript: {
    strict: true,
    typeCheck: true,
    tsConfig: {
      compilerOptions: {
        noUncheckedIndexedAccess: false,
      },
    },
  },

  postcss: {
    plugins: {
      'postcss-import': {},
      'tailwindcss/nesting': {},
      tailwindcss: {},
      cssnano: {
        preset: 'default',
      },
    },
  },

  formkit: { autoImport: true },
  experimental: { asyncContext: true },
  compatibilityDate: '2024-08-14',
  features: {
    inlineStyles: true,
  },
  extends: IS_DEV ? [] : ['./layers/error-page'],
})
