Blue Billywig
===============
This module provides integration with the Blue Billywig video platform.

The Blue Billywig video platform offers a range of features from video content
management, hosting and adaptive streaming to monetization. The entire platform
is designed to help you optimize your workflow and take your video strategy to
the next level.

Requirements
------------
This module requires the Media module in Drupal core. The Media Library module
is not required, but recommended to easily manage your media items.

To configure the API connection, you will need a Blue Billywig account and
an [API key](https://support.bluebillywig.com/sapi-reference-guide/api-key-management/).

Installation
------------
Install the module as you would normally install a contributed Drupal module.
Visit [Installing contributed modules](https://www.drupal.org/docs/8/extending-drupal-8/installing-contributed-modules)
for further information.

Configuration
-------------
Navigate to `/admin/config/media/blue-billywig` and configure the API
connection. On the configuration form, you will need to provide the following
information:
- Publication (sub)domain: Enter the subdomain for the publication. For
  example, when your publication domain is "https://example.bbvms.com", enter
  "example".
- Client identifier (optional): Enter the client identifier for the
  publication. This filters the API results for the publication.
- API Key: Enter your API key. This is the ID related to the API secret.
- API Secret: Enter your API key. This is the ID related to the API secret.

Media integration
----------------
To use Blue Billywig media items, start by creating a new media type based on
the Blue Billywig media source. Navigate to `/admin/structure/media/add` and
select "Blue Billywig" as the Media source.

When adding a new media item, you can upload new videos directly to the Blue
Billywig platform. When selecting videos using the Media library, you can also
search for existing videos on the Blue Billywig platform. The module will
automatically import the video metadata and create a media item for it.

Uppy upload widget for large file uploads
----------------
To upload large video files, it is recommended to use the Uppy upload widget.
This uploads files directly to Blue Billywig and works around possible
constraints in the webserver configuration for maximum file sizes. The widget
also supports resumable uploads and can handle network interruptions.
