<?php

namespace Drupal\blue_billywig\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\Plugin\Field\FieldType\StringItem;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the 'blue_billywig_id' field type.
 */
#[FieldType(
  id: "blue_billywig_id",
  label: new TranslatableMarkup("Blue Billywig ID"),
  description: new TranslatableMarkup("A custom field type to store IDs for Blue Billywig media items."),
  category: "plain_text",
  default_widget: "blue_billywig_id",
  default_formatter: "blue_billywig_embed_code",
  no_ui: TRUE,
  cardinality: 1
)]
class BlueBillywigIdItem extends StringItem {
}
