# Body Class Module - Version 1.1.0 Quick Start

## 🚀 Installation & Testing Guide

### Prerequisites
- Drupal 9, 10, or 11 installed
- Drush CLI tool (recommended)
- Permission to administer modules

---

## Installation

### Method 1: Using Drush (Recommended)
```bash
# Navigate to your Drupal root
cd /path/to/drupal

# Enable the module
drush en body_class -y

# Clear cache
drush cr
```

### Method 2: Using Drupal UI
1. Go to `/admin/modules`
2. Find "Body Class" in the "Other" section
3. Check the checkbox
4. Click "Install"
5. Wait for confirmation

---

## Quick Configuration Test

### Test 1: Verify Default Behavior (All Types Enabled)
```bash
# Check default configuration
drush config:get body_class.settings enabled_content_types

# Expected output:
# enabled_content_types:
#   - _all
```

### Test 2: Access Admin UI
1. Navigate to: `/admin/config/development/body_class`
2. You should see:
   - ✅ "Enable for all content types" checkbox (checked)
   - ✅ List of all content types (disabled since "all" is selected)
   - ✅ Link to "Body Class Usage List"

### Test 3: Add Body Class to a Node
1. Create or edit any node (Article, Page, etc.)
2. Look for "CSS Class(es)" field in the form
3. Enter: `test-class featured-content`
4. Save the node
5. View the node's page source
6. Find `<body>` tag - should contain: `class="... test-class featured-content ..."`

### Test 4: View Usage List
1. Navigate to: `/admin/config/development/body_class/list`
2. Should display table with your test node
3. Click column headers to test sorting
4. Click "Edit" to modify the node

### Test 5: Configure Specific Content Types
1. Go back to: `/admin/config/development/body_class`
2. Uncheck "Enable for all content types"
3. Select only "Article" (uncheck "Page" if it exists)
4. Save configuration
5. Wait for cache rebuild
6. Try creating a Page node - body_class field should NOT appear
7. Try creating an Article node - body_class field SHOULD appear

---

## Verification Checklist

- [ ] Module installs without errors
- [ ] Default config creates with `_all` enabled
- [ ] Settings page loads at `/admin/config/development/body_class`
- [ ] Usage list page loads at `/admin/config/development/body_class/list`
- [ ] Body class field appears on all node forms (default)
- [ ] Classes appear in `<body>` tag on node pages
- [ ] Can enable/disable specific content types
- [ ] Cache clears automatically on config save
- [ ] Sorting works on usage list page
- [ ] Pagination works on usage list page (test with 50+ nodes)

---

## Troubleshooting

### Issue: Field doesn't appear on node form
**Solution:**
```bash
# Clear all caches
drush cr

# Rebuild field definitions
drush php-eval "\Drupal::service('entity_field.manager')->clearCachedFieldDefinitions();"
```

### Issue: Configuration not saving
**Check permissions:**
- User must have "administer body class" permission
- Check: `/admin/people/permissions#module-body_class`

### Issue: Classes not appearing in body tag
**Debug steps:**
1. Verify field has value:
   ```bash
   drush sql:query "SELECT * FROM body_class WHERE css_class != '';"
   ```
2. Check node preprocess is running:
   ```bash
   drush eval "var_dump(\Drupal::service('module_handler')->moduleExists('body_class'));"
   ```
3. Clear cache: `drush cr`

### Issue: Admin pages show 404
**Rebuild routes:**
```bash
drush cr
# or
drush router:rebuild
```

---

## Advanced Testing

### Test Database Operations
```bash
# Check body_class table structure
drush sql:query "DESCRIBE body_class;"

# View all entries
drush sql:query "SELECT * FROM body_class;"

# Count entries
drush sql:query "SELECT COUNT(*) FROM body_class WHERE css_class != '';"
```

### Test Configuration Export/Import
```bash
# Export current config
drush config:export -y

# Modify config manually
drush config:set body_class.settings enabled_content_types.0 article

# Import from files
drush config:import -y
```

### Performance Test (Large Dataset)
```bash
# Generate 100 test nodes with body classes
drush php-eval "
for (\$i = 0; \$i < 100; \$i++) {
  \$node = \Drupal\node\Entity\Node::create([
    'type' => 'article',
    'title' => 'Test Node ' . \$i,
    'body_class' => 'test-' . \$i,
  ]);
  \$node->save();
}
echo 'Created 100 test nodes';
"

# Test pagination
# Visit: /admin/config/development/body_class/list
# Should show 50 items with pager
```

---

## Known Limitations in v1.1.0

1. **No CSS validation** - Invalid class names are not caught
2. **No autocomplete** - Can't see previously used classes
3. **No bulk operations** - Must edit nodes individually
4. **Full cache clear** - Config changes clear all caches (not targeted)

These will be addressed in v1.2.0 (see ROADMAP.md)

---

## Reporting Issues

If you find a bug:
1. Check issue queue: https://www.drupal.org/project/issues/body_class
2. Provide:
   - Drupal version
   - Steps to reproduce
   - Expected vs actual behavior
   - Error messages from logs: `drush watchdog:show`

---

## Next Steps

After successful testing:
1. Review ROADMAP.md for upcoming features
2. Check VERSION-1.1.0-IMPLEMENTATION.md for technical details
3. Consider contributing test cases or documentation improvements

**Happy testing! 🎉**
