# Body Class Module - Development Roadmap

## Current Status

- **Drupal 7 (7.x-1.x):** Stable, feature-complete with admin UI
- **Drupal 9/10/11 (1.0.x):** Limited to article content type, missing admin UI

---

## Release Plan

### 🎯 **Version 1.1.0** - Parity & Essential Fixes
**Target:** Q1 2026 | **Priority:** Critical

#### Goals
Bring D9+ version to feature parity with D7 version

#### Features
- [ ] **Universal Content Type Support**
  - Remove hardcoded 'article' limitation
  - Add configuration form to enable/disable per content type
  - Default: enabled for all content types

- [ ] **Admin UI Implementation**
  - Create `body_class.routing.yml` with settings route
  - Build configuration form (`BodyClassSettingsForm`)
  - Create admin page listing all nodes with body classes
  - Add table with node ID, title, content type, CSS classes
  - Implement pagination (50 items per page, configurable)
  - Add search/filter by content type

- [ ] **Proper Field Integration**
  - Fix `hook_entity_bundle_field_info_alter()` implementation
  - Ensure field appears in Field UI
  - Add field widget configuration

#### Technical Debt
- [ ] Add proper cache tags and cache invalidation
- [ ] Implement sanitization for CSS class input
- [ ] Update permission structure for granular access

#### Documentation
- [ ] Update README with configuration instructions
- [ ] Add screenshots of admin UI
- [ ] Create user guide for enabling content types

**Deliverables:** Stable 1.1.0 release for Drupal 9/10/11

---

### 🚀 **Version 1.2.0** - Enhanced UX
**Target:** Q2 2026 | **Priority:** High

#### Features
- [ ] **Class Autocomplete**
  - Implement autocomplete callback for previously used classes
  - Track class usage frequency
  - Show suggestions grouped by content type

- [ ] **Class Validation**
  - Validate CSS class naming conventions
  - Warn about invalid characters (spaces, special chars)
  - Auto-sanitize option (convert spaces to hyphens)
  - BEM notation helper/validator

- [ ] **Bulk Operations**
  - Add bulk edit functionality to admin UI
  - Bulk delete classes
  - Bulk find & replace classes across nodes

- [ ] **Export/Import**
  - Drush commands: `drush body-class:export`, `drush body-class:import`
  - CSV export of all node-to-class mappings
  - JSON format support for config management

#### Testing
- [ ] PHPUnit tests for database operations
- [ ] Kernel tests for all hooks
- [ ] Functional tests for admin UI
- [ ] Browser tests for autocomplete

**Deliverables:** Enhanced usability and developer tools

---

### 💡 **Version 1.3.0** - Token Integration
**Target:** Q3 2026 | **Priority:** Medium

#### Features
- [ ] **Token Support**
  - Integrate with Token module
  - Support dynamic tokens: `[node:content-type]`, `[node:nid]`, `[node:author:uid]`
  - Field tokens: `[node:field-category:entity:name]`
  - Date tokens for time-based classes

- [ ] **Token UI Integration**
  - Add token browser to body class field
  - Show available tokens in field description
  - Token replacement on render, not on save (for dynamic updates)

- [ ] **Template System**
  - Define default class patterns per content type
  - Example: `article-[node:nid] author-[node:author:uid]`
  - Store templates in configuration

#### API Enhancements
- [ ] Public API for other modules:
  ```php
  body_class_add($node, $class);
  body_class_remove($node, $class);
  body_class_get_all($node);
  body_class_has_class($node, $class);
  ```

**Deliverables:** Dynamic class generation capabilities

---

### 🌟 **Version 1.4.0** - Multi-Entity Support
**Target:** Q4 2026 | **Priority:** Medium

#### Features
- [ ] **Taxonomy Term Support**
  - Add body classes to taxonomy term pages
  - Hook into `hook_preprocess_page()` for term context
  - Term edit form integration

- [ ] **User Profile Support**
  - Add body classes to user profile pages
  - User edit form integration

- [ ] **Media Entity Support**
  - Add classes to media entities (D9+)
  - Media edit form integration

- [ ] **Generic Entity Architecture**
  - Refactor to support any entity type
  - Configuration per entity type bundle
  - Unified admin UI for all entities

#### Database Schema Update
- [ ] Migrate from node-specific table to generic entity table
- [ ] Add entity_type and entity_id columns
- [ ] Provide migration path with `hook_update_N()`

**Deliverables:** Beyond nodes - full entity support

---

### 🎨 **Version 2.0.0** - Major Architecture Overhaul
**Target:** Q1 2027 | **Priority:** Future Planning

#### Breaking Changes
- [ ] **Migrate to Field API Storage**
  - Replace custom database table with proper field storage
  - Benefits: Views integration, standard caching, core compatibility
  - Provide automated migration from 1.x to 2.x

- [ ] **Plugin Architecture**
  - Convert to plugin-based system for extensibility
  - Class providers as plugins (manual, token-based, rule-based)
  - Class validators as plugins

- [ ] **Configuration Entities**
  - Class templates as config entities
  - Exportable via config management
  - Multi-site friendly

#### New Features
- [ ] **Visual Class Builder**
  - Drag-and-drop interface for non-technical users
  - Preset class library (Bootstrap, Tailwind, custom)
  - Live preview of classes

- [ ] **Conditional Classes**
  - Rules-based class assignment
  - Conditions: user role, time, view mode, taxonomy terms
  - Example: "Add 'featured' class if node has 'Featured' tag"

- [ ] **Revision Support**
  - Track body class changes in node revisions
  - Show class diffs in revision comparison
  - Restore classes with node revision

#### Modernization
- [ ] Object-oriented services replacing procedural functions
- [ ] Dependency injection
- [ ] Event subscribers instead of hooks where applicable

**Deliverables:** Modern, scalable architecture for D10/11+

---

## 🔄 **Continuous Improvements** (All Releases)

### Documentation
- User guide with screenshots
- Developer API documentation
- Video tutorials
- Example use cases

### Performance
- Implement proper caching strategies
- Add cache tags for automatic invalidation
- Optimize database queries
- Lazy loading where applicable

### Accessibility
- WCAG 2.1 AA compliance
- Screen reader testing
- Keyboard navigation support

### Security
- Regular security reviews
- Input sanitization audits
- XSS prevention testing
- SQL injection prevention

### Code Quality
- Drupal coding standards compliance
- PHPStan level 6+ analysis
- ESLint for any JavaScript
- Automated CI/CD testing

---

## 📋 **Version Support Matrix**

| Version | Drupal Core | PHP Version | Status | EOL Date |
|---------|-------------|-------------|--------|----------|
| 7.x-1.x | Drupal 7 | 5.6 - 8.1 | Maintenance | TBD |
| 1.0.x | D9/D10/D11 | 8.1+ | Active | - |
| 1.1.x+ | D9/D10/D11 | 8.1+ | Planned | - |
| 2.0.x | D10/D11 | 8.2+ | Future | - |

---

## 🤝 **Community Feedback**

We welcome feedback on this roadmap! Please:
- Open issues on drupal.org project page for feature requests
- Comment on the roadmap issue queue
- Join discussions in Drupal Slack #body-class channel
- Submit patches for features you'd like to see

---

## 📅 **Release Schedule Guidelines**

- **Patch releases (1.x.y):** Bug fixes, security updates - as needed
- **Minor releases (1.x.0):** New features, backwards compatible - quarterly
- **Major releases (x.0.0):** Breaking changes, architecture changes - yearly

---

## 🎯 **Success Metrics**

- Active installations > 10,000
- Issue response time < 7 days
- Test coverage > 80%
- Drupal.org project rating > 4.5/5
- Security coverage maintained

---

**Last Updated:** November 12, 2025
**Maintainer:** Jaseer Kinangattil (@JaseerKinangattil)
