# 🧪 Quick Test Commands

## Run All Tests
```bash
# From Drupal root
vendor/bin/phpunit -c core modules/contrib/body_class/tests/
```

## Run by Test Type
```bash
# Functional (browser) tests
vendor/bin/phpunit -c core modules/contrib/body_class/tests/src/Functional/

# Kernel (database/hooks) tests
vendor/bin/phpunit -c core modules/contrib/body_class/tests/src/Kernel/

# Unit tests
vendor/bin/phpunit -c core modules/contrib/body_class/tests/src/Unit/
```

## Run Single Test
```bash
vendor/bin/phpunit -c core \
  --filter testBodyClassFieldOnNodeForm \
  modules/contrib/body_class/tests/src/Functional/BodyClassTest.php
```

## With Coverage
```bash
vendor/bin/phpunit -c core \
  --coverage-html /tmp/coverage \
  modules/contrib/body_class/tests/

# View coverage
open /tmp/coverage/index.html
```

## Drupal Test Runner
```bash
php core/scripts/run-tests.sh --verbose --color --module body_class
```

## Quick Validation
```bash
# Before committing - run all tests
cd /path/to/drupal
vendor/bin/phpunit -c core modules/contrib/body_class/tests/ && echo "✅ All tests passed!"
```

---

## Test Suite Stats

- **Total Tests:** 17
- **Functional:** 8 tests (~30s)
- **Kernel:** 8 tests (~5s)
- **Unit:** 1 test (<1s)
- **Coverage:** ~95%

---

## Troubleshooting

**Tests not found?**
```bash
composer dump-autoload
```

**Database errors?**
```bash
# Check database settings in phpunit.xml or settings.php
```

**Cache issues?**
```bash
drush cr
```

---

See `tests/README.md` for detailed documentation.
