# Book module

A book is a set of nodes tied together in a hierarchical structure, with
chapters, sections, and subsections. You can use books for manuals, site
resource guides, Frequently Asked Questions (FAQ), novel, or curricula.
Any content type can be added to a book, and a book can contain nodes of more
than one content type.

For a full description of the module, visit the
[project page](https://drupal.org/project/book).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://drupal.org/project/issues/book).

## Table of contents

- Installation
- Configuration
- Enhancements
- Alternatives
- Maintainers

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

Recommend reading https://www.drupal.org/docs/contributed-modules/book/overview

## Enhancements/Alternatives

Modules that provide additional support for book:

* [Book PDF](https://www.drupal.org/project/book_pdf) - This module provides a means to print books and relies on a third party library for pdf generation.
* [Book Access Code](https://www.drupal.org/project/book_access_code) - Provide arbitrary access to books by exposing them to those that have a book code.
  This could be used in many ways.
* [Custom book block](https://www.drupal.org/project/custom_book_block) - A more configurable version of the navigation block
* [Book tree menu](https://www.drupal.org/project/book_tree_menu) - Book Tree Menu enhances the default book navigation
* [Booktree](https://www.drupal.org/project/booktree) - Booktree module - take as input a series of Book nodes and create a tree-like structure using Book node
  relationships. Similar to booktree_menu.
* [Sync book index to Drupal core menu](https://www.drupal.org/project/book_menu_sync) - module provides an easy-to-use solution for converting a Drupal
  book structure into a standard Drupal menu.

## Alternatives

- [Entity Reference Hierarchy](https://www.drupal.org/project/entity_hierarchy)

## Maintainers

- Peter Wolanin [pwolanin](https://www.drupal.org/u/pwolanin)
- Stephen Mustgrave - [smustgrave](https://www.drupal.org/u/smustgrave)
