<?php

namespace Drupal\Tests\book\Kernel;

use Drupal\book\BookHelperTrait;
use Drupal\Core\Form\FormState;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\node\Traits\ContentTypeCreationTrait;
use Drupal\book\Form\BookSettingsForm;

/**
 * @covers \Drupal\book\Form\BookSettingsForm
 * @group book
 */
class BookSettingsFormTest extends KernelTestBase {

  use BookHelperTrait;
  use ContentTypeCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'book',
    'book_content_type',
    'field',
    'node',
    'system',
    'text',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(['book', 'book_content_type', 'node']);
    $this->createContentType(['type' => 'chapter']);
    $this->createContentType(['type' => 'page']);

    // Clear default config that might include book type.
    $this->config('book.settings')
      ->set('allowed_types', [])
      ->set('book_sort', 'weight')
      ->save();
  }

  /**
   * Tests that submitted values are processed and saved correctly.
   *
   * @throws \Exception
   */
  public function testConfigValuesSavedCorrectly(): void {
    $form_state = new FormState();
    $form_state->setValues([
      'allowed_types' => [
        'page' => [
          'enabled' => TRUE,
          'child_type' => 'page',
        ],
        'chapter' => [
          'enabled' => TRUE,
          'child_type' => 'page',
        ],
      ],
      'book_sort' => 'weight',
    ]);
    $this->container->get('form_builder')->submitForm(BookSettingsForm::class, $form_state);

    $config = $this->config('book.settings');
    $allowed_types_config = $config->get('allowed_types');
    $content_types = $this->getBookContentTypes($allowed_types_config);
    $this->assertSame(['chapter', 'page'], $content_types);
    $this->assertSame('page', $allowed_types_config[0]['child_type']);
  }

}
