# Book Organizer

Book Organizer delivers a clean, Views-powered administration experience for Drupal books.
It surfaces every top-level book alongside its nested pages in a single hierarchy-aware table, so editors can scan, filter, and jump into key tasks without leaving the content overview.

## Features

- **Hierarchical table:** Books render as headings with their child pages indented beneath them, mirroring the native book structure.
- **Views filters:** Title, status, and language filters work out of the box; extend the `book_organized` view through the UI for additional criteria.
- **Quick operations:** Edit, view, and order links are exposed for both books and pages according to user permissions.
- **Standalone support:** Book nodes that are not part of a hierarchy remain visible, clearly marked as standalone entries.

## Requirements

- Book module (`book`)
- Core Views module (`views`)

## Usage

- Navigate to **Content → Books (Organized)** (`/admin/content/book-organized`) to browse the hierarchy.
- Use the exposed filters to narrow results by title, publication status, or language.
- Click the book title for the standard node display or “Order pages” to launch the core Book outline UI.
- The contextual tab remains available alongside **Content** for quick access.

## Customization

- The view is saved as `book_organized`. Clone or edit it through the Views UI to add columns, filters, bulk operations, or alternative displays.
- The custom style plugin (`Book hierarchy table`) lives in `src/Plugin/views/style/BookHierarchyTable.php`; it controls how top-level rows and child rows render.
- The hierarchy helper service is available as `book_organizer.hierarchy_manager` if you need programmatic access to ordered book nodes.
