<?php

namespace Drupal\bootstrap3\Plugin\Setting\JavaScript\Modals;

use Drupal\bootstrap3\Plugin\Setting\SettingBase;

/**
 * The "modal_keyboard" theme setting.
 *
 * @ingroup plugins_setting
 *
 * @BootstrapSetting(
 *   id = "modal_keyboard",
 *   type = "checkbox",
 *   title = @Translation("keyboard"),
 *   description = @Translation("Closes the modal when escape key is pressed."),
 *   defaultValue = 1,
 *   groups = {
 *     "javascript" = @Translation("JavaScript"),
 *     "modals" = @Translation("Modals"),
 *     "options" = @Translation("Options"),
 *   },
 * )
 */
class ModalKeyboard extends SettingBase {

  /**
   * {@inheritdoc}
   */
  public function drupalSettings() {
    return !!$this->theme->getSetting('modal_enabled');
  }

}
