<?php

namespace Drupal\bootstrap3\Plugin\Setting\JavaScript\Popovers;

use Drupal\bootstrap3\Plugin\Setting\SettingBase;

/**
 * The "popover_container" theme setting.
 *
 * @ingroup plugins_setting
 *
 * @BootstrapSetting(
 *   id = "popover_container",
 *   type = "textfield",
 *   title = @Translation("container"),
 *   description = @Translation("Appends the popover to a specific element. Example: <code>body</code>. This option is particularly useful in that it allows you to position the popover in the flow of the document near the triggering element - which will prevent the popover from floating away from the triggering element during a window resize."),
 *   defaultValue = "body",
 *   groups = {
 *     "javascript" = @Translation("JavaScript"),
 *     "popovers" = @Translation("Popovers"),
 *     "options" = @Translation("Options"),
 *   },
 * )
 */
class PopoverContainer extends SettingBase {

  /**
   * {@inheritdoc}
   */
  public function drupalSettings() {
    return !!$this->theme->getSetting('popover_enabled');
  }

}
