<?php

namespace Drupal\bootstrap3\Plugin\Update;

use Drupal\bootstrap3\Bootstrap;
use Drupal\bootstrap3\Plugin\PluginBase;
use Drupal\bootstrap3\Theme;

/**
 * Base class for an update.
 *
 * @ingroup plugins_update
 */
class UpdateBase extends PluginBase implements UpdateInterface {

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->pluginDefinition['description'] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return !empty($this->pluginDefinition['label']) ? $this->pluginDefinition['label'] : NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getProvider() {
    return $this->pluginDefinition['provider'] ?? FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getSchema() {
    return (int) $this->getPluginId();
  }

  /**
   * {@inheritdoc}
   */
  public function getSeverity() {
    return $this->pluginDefinition['severity'] ?? FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getTheme() {
    return Bootstrap::getTheme($this->pluginDefinition['provider']);
  }

  /**
   * {@inheritdoc}
   */
  public function isPrivate() {
    return !empty($this->pluginDefinition['private']);
  }

  /**
   * {@inheritdoc}
   */
  public function process(Theme $theme, array &$context) {
    return TRUE;
  }

  /*************************
   * Deprecated methods.
   *************************/

  /**
   * {@inheritdoc}
   *
   * @deprecated 8.x-3.0-rc2, will be removed before 8.x-3.0 is released.
   *
   * @see \Drupal\bootstrap3\Plugin\Update\UpdateBase::getSeverity
   */
  public function getLevel() {
    return $this->getSeverity();
  }

  /**
   * {@inheritdoc}
   *
   * @deprecated 8.x-3.0-rc2, will be removed before 8.x-3.0 is released.
   *
   * @see \Drupal\bootstrap3\Plugin\Update\UpdateBase::getLabel
   */
  public function getTitle() {
    return $this->getLabel();
  }

}
