<?php

namespace Drupal\bootstrap3\Plugin\Setting\JavaScript\Popovers;

use Drupal\bootstrap3\Plugin\Setting\SettingBase;

/**
 * The "popover_content" theme setting.
 *
 * @ingroup plugins_setting
 *
 * @BootstrapSetting(
 *   id = "popover_content",
 *   type = "textfield",
 *   title = @Translation("content"),
 *   description = @Translation("Default content value if <code>data-content</code> or <code>data-target</code> attributes are not present."),
 *   defaultValue = "",
 *   groups = {
 *     "javascript" = @Translation("JavaScript"),
 *     "popovers" = @Translation("Popovers"),
 *     "options" = @Translation("Options"),
 *   },
 * )
 */
class PopoverContent extends SettingBase {

  /**
   * {@inheritdoc}
   */
  public function drupalSettings() {
    return !!$this->theme->getSetting('popover_enabled');
  }

}
