/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
((Drupal, once) => {
  function init(index, tab) {
    const target = tab.querySelector('[data-drupal-nav-tabs-target]');

    const openMenu = () => {
      target.classList.toggle('is-open');
      const toggle = target.querySelector('.tab-toggle');
      const isExpanded = toggle.getAttribute('aria-expanded') === 'true';
      toggle.setAttribute('aria-expanded', !isExpanded);
    };

    tab.addEventListener('click', (event) => {
      if (event.target.matches('[data-drupal-nav-tabs-toggle]')) {
        openMenu();
      }
    });
  }

  /**
   * Initialize the tabs JS.
   */
  Drupal.behaviors.navTabs = {
    attach(context) {
      const elements = once(
        'nav-tabs',
        '[data-drupal-nav-tabs].is-collapsible',
        context,
      );
      elements.forEach((element, index) => {
        init(index, element);
      });
    },
  };
})(Drupal, once);
