# Bootstrap Components (Lightweight SDC Library)

A lightweight collection of **Bootstrap 5 Single Directory Components (SDC)** for Drupal 10/11.

> Most component structure and ideas are adapted / inspired by the `ui_suite_bootstrap` project. All primary credit for the original patterns belongs to that team – this module intentionally provides a slimmer, easier‑to‑audit subset without the broader ecosystem overhead.

## Features

- Modern **SDC** definitions (modal, alert, button, close-button starter set)
- Clean **`to_attributes` Twig filter/function** for reliable attribute normalization
- Optional variant & slot patterns consistent with Drupal core SDC direction
- Zero JS build step required (relies on Bootstrap already present on your site)

## Included Components

| Component       | Slots (if any)      | Notable Props / Variants              |
|-----------------|---------------------|---------------------------------------|
| `modal`         | title, body, footer | animation, static, centered, scrollable, fullscreen, heading_level |
| `alert`         | body (implicit)     | variant (primary, secondary, success, danger, warning, info, light, dark), dismissible |
| `button`        | (label via prop)    | variant, size, outline, disabled, attributes |
| `close-button`  | (none)              | visually_hidden_text                  |

## Twig Helper: `to_attributes`

Added via `AttributesToolTwigExtension` and exposed as both a filter & function.

Usage examples:
```twig
{# From a space-delimited string #}
<div{{ 'alpha beta'|to_attributes }}></div>

{# From an array of classes #}
<div{{ ['alpha','beta']|to_attributes }}></div>

{# From an associative array #}
<div{{ { class: ['alpha','beta'], id: 'example', 'data-role': 'dialog' }|to_attributes }}></div>
```

It always returns a `Drupal\Core\Template\Attribute` object, making it safe to chain `.addClass()` in Twig.

## Installation

1. Place this module in: `docroot/modules/custom/bootstrap_components`
2. Ensure Bootstrap (CSS & JS + Popper) is loaded globally (theme or library).
3. Enable the module:
```bash
drush en bootstrap_components -y
```
4. Clear caches:
```bash
drush cr
```

## Using Components in Twig

All SDC components are invokable via the `component` render element or implicitly when referenced from other components.

Example (Button inside Alert footer using raw component invocation):
```twig
{{ render({
  '#type': 'component',
  '#component': 'bootstrap_components:button',
  '#props': {
    label: 'Click me',
    variant: 'primary'
  }
}) }}
```

Example (Modal):
```twig
{{ render({
  '#type': 'component',
  '#component': 'bootstrap_components:modal',
  '#props': {
    title: 'Demo modal',
    body: 'Simple body text',
    animation: true,
    centered: true
  }
}) }}
```

Example (Alert):
```twig
{{ render({
  '#type': 'component',
  '#component': 'bootstrap_components:alert',
  '#props': {
    body: 'Saved successfully',
    variant: 'success',
    dismissible: true
  }
}) }}
```

## Stories

Story YAML files (e.g. `modal.default.story.yml`) live under each component `stories/` folder and are auto-discovered (if you integrate with a consumer using `StoryDiscovery`). They follow this filename pattern:
```
{component}.{key}.story.yml
```

Example excerpt:
```yaml
name: "Default modal"
props:
  title: "Example"
  body: "<p>Lorem ipsum</p>"
  animation: true
```

## Credits

- Heavy inspiration & numerous original patterns: **ui_suite_bootstrap** (thank you!).
- Drupal SDC / Component initiative.

## License

MIT (see component source headers where applicable). If you adapt more code directly from `ui_suite_bootstrap`, please retain their attribution per file.

## Roadmap / Ideas

- Additional core Bootstrap components (accordion, offcanvas, navbar, toast)
- Optional accessibility audit helper output in dev mode
- Expanded story metadata for automated visual regression harnesses

Pull requests / issues welcome.

