# Bootstrap 5 Utilities CSS Classes

This file lists all unique CSS classes available in the Bootstrap 5 Utilities system from `bootstrap-utilities.css`.

## Total Classes: 1,292

### Major Categories

#### Alignment Utilities
- **Vertical Alignment**: `align-baseline`, `align-top`, `align-middle`, `align-bottom`, `align-text-bottom`, `align-text-top`
- **Flex Alignment**: `align-content-*`, `align-items-*`, `align-self-*` (with responsive variants)
- **Justify Content**: `justify-content-start`, `justify-content-end`, `justify-content-center`, `justify-content-between`, `justify-content-around`, `justify-content-evenly`

#### Background Utilities
- **Background Colors**: `bg-primary`, `bg-secondary`, `bg-success`, `bg-danger`, `bg-warning`, `bg-info`, `bg-light`, `bg-dark`, `bg-white`, `bg-transparent`
- **Background Opacity**: `bg-opacity-10`, `bg-opacity-25`, `bg-opacity-50`, `bg-opacity-75`, `bg-opacity-100`
- **Background Gradient**: `bg-gradient`

#### Border Utilities
- **Border**: `border`, `border-0`, `border-top`, `border-end`, `border-bottom`, `border-start`
- **Border Colors**: `border-primary`, `border-secondary`, etc.
- **Border Opacity**: `border-opacity-10`, `border-opacity-25`, etc.
- **Border Radius**: `rounded`, `rounded-0`, `rounded-1`, `rounded-2`, `rounded-3`, `rounded-circle`, `rounded-pill`
- **Border Width**: `border-1`, `border-2`, `border-3`, `border-4`, `border-5`

#### Display Utilities
- **Display Types**: `d-none`, `d-inline`, `d-inline-block`, `d-block`, `d-grid`, `d-table`, `d-table-row`, `d-table-cell`, `d-flex`, `d-inline-flex`
- **Responsive Display**: All display utilities with responsive breakpoints (`d-sm-*`, `d-md-*`, `d-lg-*`, `d-xl-*`, `d-xxl-*`)

#### Flex Utilities
- **Flex Direction**: `flex-row`, `flex-row-reverse`, `flex-column`, `flex-column-reverse`
- **Flex Wrap**: `flex-wrap`, `flex-nowrap`, `flex-wrap-reverse`
- **Flex Fill**: `flex-fill`
- **Flex Grow/Shrink**: `flex-grow-0`, `flex-grow-1`, `flex-shrink-0`, `flex-shrink-1`
- **Order**: `order-0` through `order-5`, `order-first`, `order-last`

#### Float Utilities
- **Float**: `float-start`, `float-end`, `float-none`
- **Responsive Float**: With all breakpoint variants

#### Gap Utilities
- **Gap**: `gap-0`, `gap-1`, `gap-2`, `gap-3`, `gap-4`, `gap-5`
- **Row/Column Gap**: `row-gap-*`, `column-gap-*`
- **Responsive Gaps**: With all breakpoint variants

#### Height Utilities
- **Height**: `h-25`, `h-50`, `h-75`, `h-100`, `h-auto`
- **Min/Max Height**: `mh-100`, `min-vh-100`, `vh-100`

#### Margin Utilities
- **All Sides**: `m-0`, `m-1`, `m-2`, `m-3`, `m-4`, `m-5`, `m-auto`
- **Horizontal**: `mx-0`, `mx-1`, `mx-2`, `mx-3`, `mx-4`, `mx-5`, `mx-auto`
- **Vertical**: `my-0`, `my-1`, `my-2`, `my-3`, `my-4`, `my-5`, `my-auto`
- **Individual Sides**: `mt-*`, `me-*`, `mb-*`, `ms-*` (top, end, bottom, start)
- **Responsive Margins**: All margin utilities with responsive breakpoints
- **Negative Margins**: `m-n1`, `m-n2`, `m-n3`, `m-n4`, `m-n5` (and directional variants)

#### Padding Utilities
- **All Sides**: `p-0`, `p-1`, `p-2`, `p-3`, `p-4`, `p-5`
- **Horizontal**: `px-0`, `px-1`, `px-2`, `px-3`, `px-4`, `px-5`
- **Vertical**: `py-0`, `py-1`, `py-2`, `py-3`, `py-4`, `py-5`
- **Individual Sides**: `pt-*`, `pe-*`, `pb-*`, `ps-*` (top, end, bottom, start)
- **Responsive Padding**: All padding utilities with responsive breakpoints

#### Position Utilities
- **Position**: `position-static`, `position-relative`, `position-absolute`, `position-fixed`, `position-sticky`
- **Responsive Position**: With all breakpoint variants
- **Positioning**: `top-0`, `top-50`, `top-100`, `bottom-0`, `bottom-50`, `bottom-100`, `start-0`, `start-50`, `start-100`, `end-0`, `end-50`, `end-100`
- **Translate**: `translate-middle`, `translate-middle-x`, `translate-middle-y`

#### Shadow Utilities
- **Box Shadow**: `shadow-none`, `shadow-sm`, `shadow`, `shadow-lg`


#### Visibility Utilities
- **Visibility**: `visible`, `invisible`
- **Screen Reader**: `visually-hidden`, `visually-hidden-focusable`

#### Width Utilities
- **Width**: `w-25`, `w-50`, `w-75`, `w-100`, `w-auto`
- **Min/Max Width**: `mw-100`, `min-vw-100`, `vw-100`

#### Z-Index Utilities
- **Z-Index**: `z-n1`, `z-0`, `z-1`, `z-2`, `z-3`

#### Interaction Utilities
- **User Select**: `user-select-all`, `user-select-auto`, `user-select-none`
- **Pointer Events**: `pe-none`, `pe-auto`

#### Overflow Utilities
- **Overflow**: `overflow-auto`, `overflow-hidden`, `overflow-visible`, `overflow-scroll`
- **Overflow X/Y**: `overflow-x-auto`, `overflow-x-hidden`, `overflow-x-visible`, `overflow-x-scroll`
- **Overflow Y**: `overflow-y-auto`, `overflow-y-hidden`, `overflow-y-visible`, `overflow-y-scroll`

#### Object Fit Utilities
- **Object Fit**: `object-fit-contain`, `object-fit-cover`, `object-fit-fill`, `object-fit-scale`, `object-fit-none`

#### Stack Utilities
- **Horizontal Stack**: `hstack`
- **Vertical Stack**: `vstack`

#### Vertical Rule Utility
- **Vertical Rule**: `vr`

### Responsive Breakpoints
Most utilities support responsive variants:
- **sm**: ≥576px
- **md**: ≥768px
- **lg**: ≥992px
- **xl**: ≥1200px
- **xxl**: ≥1400px
