<?php

namespace Drupal\bootstrap_five_layouts_viewsstyle;

use Drupal\Component\Utility\Html;
use Drupal\views\ViewExecutable;

/**
 * The primary class for the Views Bootstrap module.
 *
 * Provides many helper methods.
 *
 * @ingroup utility
 */
class BootstrapFiveLayoutsViewsstyle {

  /**
   * Returns the theme hook definition information.
   */
  public static function getThemeHooks(): array {
    $hooks['bootstrap_five_layouts_viewsstyle_grid'] = [
      'preprocess functions' => [
        'template_preprocess_bootstrap_five_layouts_viewsstyle_grid',
      ],
      'file' => 'bootstrap_five_layouts_viewsstyle.theme.inc',
    ];
    return $hooks;
  }

  /**
   * Return an array of breakpoint names.
   */
  public static function getBreakpoints(): array {
    return ['xs', 'sm', 'md', 'lg', 'xl', 'xxl'];
  }

  /**
   * Get column class prefix for the breakpoint.
   */
  public static function getColumnPrefix($breakpoint): string {
    return 'col' . ($breakpoint != 'xs' ? '-' . $breakpoint : '');
  }

  /**
   * Get unique element id.
   *
   * @param \Drupal\views\ViewExecutable $view
   *   A ViewExecutable object.
   *
   * @return string
   *   A unique id for an HTML element.
   */
  public static function getUniqueId(ViewExecutable $view): string {
    $id = $view->storage->id() . '-' . $view->current_display;
    return Html::getUniqueId('bootstrap-five-layouts-viewsstyle-' . $id);
  }

}
