<?php

namespace Drupal\bootstrap_five_layouts;

use Drupal\Core\Extension\ModuleUninstallValidatorInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Class BootstrapFiveLayoutsUninstallValidator.
 */
class BootstrapFiveLayoutsUninstallValidator implements ModuleUninstallValidatorInterface {

  use StringTranslationTrait;

  /**
   * The BootstrapFiveLayouts manager.
   *
   * @var \Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager
   */
  protected $manager;

  /**
   * Constructs a new ContentUninstallValidator.
   *
   * @param \Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager $manager
   *   The BootstrapFiveLayouts manager.
   */
  public function __construct(BootstrapFiveLayoutsManager $manager) {
    $this->manager = $manager;
  }

  /**
   * {@inheritdoc}
   */
  public function validate($module) {
    $reasons = [];

    if ($module === 'bootstrap_five_layouts') {
      $layouts = [];
      foreach ($this->manager->getHandlers() as $handler) {
        foreach ($handler->loadInstances() as $storage_id => $layout) {
          if ($layout->isBootstrapFiveLayout()) {
            $layouts[$layout->getId()][] = $handler->getPluginId() . ':' . $storage_id;
          }
        }
      }
      ksort($layouts);
      foreach ($layouts as $layout_id => $storage_ids) {
        sort($storage_ids, SORT_NATURAL);
        $reasons[] = $this->t('Using layout: @layout_id (@storage_ids)', [
          '@layout_id' => $layout_id,
          '@storage_ids' => implode(', ', $storage_ids),
        ]);
      }
    }

    return $reasons;
  }

}
