<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\Component\Plugin\DerivativeInspectionInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Interface BootstrapFiveLayoutsHandlerInterface.
 */
interface BootstrapFiveLayoutsHandlerInterface extends ContainerFactoryPluginInterface, DerivativeInspectionInterface, PluginInspectionInterface {

  /**
   * Retrieves the human readable label for the plugin.
   *
   * @return string
   *   The human readable label.
   */
  public function getLabel();

  /**
   * Loads a specific layout instance.
   *
   * @param string|int $id
   *   The identifier to load.
   *
   * @return \Drupal\bootstrap_five_layouts\BootstrapFiveLayout
   *   The BootstrapFiveLayout instance.
   */
  public function loadInstance($id);

  /**
   * Loads layout instances.
   *
   * @param string[]|int[] $ids
   *   Optional. An array of identifiers to load. If no identifiers are
   *   specified, then all available instances will be loaded.
   *
   * @return \Drupal\bootstrap_five_layouts\BootstrapFiveLayout[]
   *   An associative array of BootstrapFiveLayout instances, keyed by identifier.
   */
  public function loadInstances(?array $ids = NULL);

  /**
   * Saves a specific layout instance.
   *
   * @param string|int $id
   *   The identifier to save.
   * @param \Drupal\bootstrap_five_layouts\BootstrapFiveLayout $layout
   *   The layout instance info array.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   *   In case of failures an exception is thrown.
   */
  public function saveInstance($id, BootstrapFiveLayout $layout);

  /**
   * Saves layout instances.
   *
   * @param \Drupal\bootstrap_five_layouts\BootstrapFiveLayout[] $layouts
   *   An associative array of BootstrapFiveLayout instances, keyed by identifier.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   *   In case of failures an exception is thrown.
   */
  public function saveInstances(array $layouts = []);

}
