<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager;
use Drupal\Core\Plugin\PluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 *
 */
class BootstrapFiveLayoutsUpdateBase extends PluginBase implements BootstrapFiveLayoutsUpdateInterface {

  /**
   * The path to the provider.
   *
   * @var string
   */
  protected $path;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ?ContainerInterface $container = NULL) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    if (!isset($container)) {
      $container = \Drupal::getContainer();
    }
    $this->setContainer($container);

    // Retrieve the path to provider.
    $this->path = \Drupal::service('extension.list.module')->getPath($this->pluginDefinition['provider']) ?: \Drupal::service('extension.list.theme')->getPath($this->pluginDefinition['provider']);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static($configuration, $plugin_id, $plugin_definition, $container);
  }

  /**
   * {@inheritdoc}
   */
  public function getPath() {
    return $this->path;
  }

  /**
   * {@inheritdoc}
   */
  public function update(BootstrapFiveLayoutsManager $manager, array $data = [], $display_messages = TRUE) {
  }

  /**
   * {@inheritdoc}
   */
  public function processExistingLayout(BootstrapFiveLayout $layout, array $data = [], $display_messages = TRUE) {
  }

}
