<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager;
use Drupal\Component\Plugin\DerivativeInspectionInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 *
 */
interface BootstrapFiveLayoutsUpdateInterface extends ContainerFactoryPluginInterface, DerivativeInspectionInterface, PluginInspectionInterface {

  /**
   * Retrieves the path to plugin provider.
   *
   * @return string
   *   Path to the plugin provider.
   */
  public function getPath();

  /**
   * Provide an update.
   *
   * @param \Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager $manager
   *   The BootstrapFiveLayoutsManager instance.
   * @param array $data
   *   Any static YAML data found for the update.
   * @param bool $display_messages
   *   Flag determining whether a message will be displayed indicating whether
   *   the layout was processed successfully or not.   *.
   */
  public function update(BootstrapFiveLayoutsManager $manager, array $data = [], $display_messages = TRUE);

  /**
   * Provide an update for an existing layout.
   *
   * Note: this process any existing layout and is not specific to just
   * "Bootstrap Layouts" based layouts. If implementing this update, you should
   * check the $layout->getId() before performing any tasks.
   *
   * @param \Drupal\bootstrap_five_layouts\BootstrapFiveLayout $layout
   *   The existing BootstrapFiveLayout instance that is being processed.
   * @param array $data
   *   Any static YAML data found for the update.
   * @param bool $display_messages
   *   Flag determining whether a message will be displayed indicating whether
   *   the layout was processed successfully or not.
   *
   * @see \Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager::update()
   */
  public function processExistingLayout(BootstrapFiveLayout $layout, array $data = [], $display_messages = TRUE);

}
