# Bootstrap 5 CSS Loader for Drupal Layouts

This module provides automated compilation of Bootstrap 5 grid and utilities CSS for the Bootstrap Five Layouts Drupal module.

## Generated Files

### Grid System (Grid layout classes only)
- `css/bootstrap-grid.css` - Expanded Bootstrap 5 grid system
- `css/bootstrap-grid.min.css`  - Minified grid system

### Utilities (Layout and spacing utilities)
- `css/bootstrap-utilities.css` - All Bootstrap 5 utilities
- `css/bootstrap-utilities.min.css` - Minified utilities

All files include source maps for development.

## npm Scripts

```bash
# Build individual components
npm run build:grid          # Build expanded grid CSS
npm run build:grid:min      # Build minified grid CSS
npm run build:utilities     # Build utilities CSS
npm run build:utilities:min # Build minified utilities CSS

# Build all files
npm run build:all           # Build everything

# Development workflow
npm run watch               # Watch for changes and rebuild
npm run dev                 # Build all + start watch
```

## Watch Process

The watch process monitors the `scss/` directory for changes and automatically rebuilds the CSS files. Start it with:

```bash
npm run watch
```

## Source Files

- `scss/bootstrap-grid.scss` - Bootstrap 5 grid compilation source
- `scss/bootstrap-utilities.scss` - Bootstrap 5 utilities compilation source

## Usage in Drupal

### Automatic Loading (Recommended)

This module automatically loads Bootstrap CSS on all pages. Configure the settings at:
**Administration → Configuration → User Interface → Bootstrap CSS Loader**

Available options:
- **Library Selection**: Choose which CSS to load (Complete, Grid only, Utilities only, or None)
- **Loading Method**: How to attach the CSS (Page Attachments, Page Preprocess, or HTML Preprocess)

### Manual Library Usage

You can also manually include specific libraries in your Drupal theme or modules:

```yaml
# In your .libraries.yml file
dependencies:
  - bootstrap_five_layouts_css_loader/toolkit
```

## Dependencies

- Bootstrap 5.3.0
- Sass compiler

The deprecation warnings from Sass are expected and come from Bootstrap's SCSS files. They don't affect the functionality.
