# Bootstrap 5 Grid CSS Classes

This file lists all unique CSS classes available in the Bootstrap 5 Grid system from `bootstrap-grid.css`.

## Total Classes: 313

### Container Classes
- `container` - Responsive fixed-width container
- `container-fluid` - Full-width container
- `container-sm` - Container with small breakpoint max-width
- `container-md` - Container with medium breakpoint max-width  
- `container-lg` - Container with large breakpoint max-width
- `container-xl` - Container with extra large breakpoint max-width
- `container-xxl` - Container with extra extra large breakpoint max-width

### Row Classes
- `row` - Creates a flex row for columns

### Column Classes

#### Base Column Classes
- `col` - Auto-sizing column
- `col-auto` - Auto-width column

#### Numbered Column Classes (1-12)
- `col-1` through `col-12` - Fixed width columns

#### Responsive Column Classes

##### Small (sm) - ≥576px
- `col-sm` - Auto-sizing column on small screens and up
- `col-sm-auto` - Auto-width column on small screens and up
- `col-sm-1` through `col-sm-12` - Fixed width columns on small screens and up

##### Medium (md) - ≥768px
- `col-md` - Auto-sizing column on medium screens and up
- `col-md-auto` - Auto-width column on medium screens and up
- `col-md-1` through `col-md-12` - Fixed width columns on medium screens and up

##### Large (lg) - ≥992px
- `col-lg` - Auto-sizing column on large screens and up
- `col-lg-auto` - Auto-width column on large screens and up
- `col-lg-1` through `col-lg-12` - Fixed width columns on large screens and up

##### Extra Large (xl) - ≥1200px
- `col-xl` - Auto-sizing column on extra large screens and up
- `col-xl-auto` - Auto-width column on extra large screens and up
- `col-xl-1` through `col-xl-12` - Fixed width columns on extra large screens and up

##### Extra Extra Large (xxl) - ≥1400px
- `col-xxl` - Auto-sizing column on extra extra large screens and up
- `col-xxl-auto` - Auto-width column on extra extra large screens and up
- `col-xxl-1` through `col-xxl-12` - Fixed width columns on extra extra large screens and up

### Row Columns Classes

#### Base Row Columns
- `row-cols-auto` - Auto-sizing columns in row
- `row-cols-1` through `row-cols-6` - Number of columns per row

#### Responsive Row Columns

##### Small (sm)
- `row-cols-sm-auto` - Auto-sizing columns in row on small screens and up
- `row-cols-sm-1` through `row-cols-sm-6` - Number of columns per row on small screens and up

##### Medium (md)
- `row-cols-md-auto` - Auto-sizing columns in row on medium screens and up
- `row-cols-md-1` through `row-cols-md-6` - Number of columns per row on medium screens and up

##### Large (lg)
- `row-cols-lg-auto` - Auto-sizing columns in row on large screens and up
- `row-cols-lg-1` through `row-cols-lg-6` - Number of columns per row on large screens and up

##### Extra Large (xl)
- `row-cols-xl-auto` - Auto-sizing columns in row on extra large screens and up
- `row-cols-xl-1` through `row-cols-xl-6` - Number of columns per row on extra large screens and up

##### Extra Extra Large (xxl)
- `row-cols-xxl-auto` - Auto-sizing columns in row on extra extra large screens and up
- `row-cols-xxl-1` through `row-cols-xxl-6` - Number of columns per row on extra extra large screens and up

### Offset Classes

#### Base Offsets
- `offset-1` through `offset-11` - Push columns to the right

#### Responsive Offsets

##### Small (sm)
- `offset-sm-0` through `offset-sm-11` - Column offsets on small screens and up

##### Medium (md)
- `offset-md-0` through `offset-md-11` - Column offsets on medium screens and up

##### Large (lg)
- `offset-lg-0` through `offset-lg-11` - Column offsets on large screens and up

##### Extra Large (xl)
- `offset-xl-0` through `offset-xl-11` - Column offsets on extra large screens and up

##### Extra Extra Large (xxl)
- `offset-xxl-0` through `offset-xxl-11` - Column offsets on extra extra large screens and up

### Gutter Classes

#### Base Gutters
- `g-0` through `g-5` - Gap/gutter spacing for both x and y axes
- `gx-0` through `gx-5` - Horizontal gap/gutter spacing
- `gy-0` through `gy-5` - Vertical gap/gutter spacing

#### Responsive Gutters

##### Small (sm)
- `g-sm-0` through `g-sm-5` - Gap spacing on small screens and up
- `gx-sm-0` through `gx-sm-5` - Horizontal gap spacing on small screens and up
- `gy-sm-0` through `gy-sm-5` - Vertical gap spacing on small screens and up

##### Medium (md)
- `g-md-0` through `g-md-5` - Gap spacing on medium screens and up
- `gx-md-0` through `gx-md-5` - Horizontal gap spacing on medium screens and up
- `gy-md-0` through `gy-md-5` - Vertical gap spacing on medium screens and up

##### Large (lg)
- `g-lg-0` through `g-lg-5` - Gap spacing on large screens and up
- `gx-lg-0` through `gx-lg-5` - Horizontal gap spacing on large screens and up
- `gy-lg-0` through `gy-lg-5` - Vertical gap spacing on large screens and up

##### Extra Large (xl)
- `g-xl-0` through `g-xl-5` - Gap spacing on extra large screens and up
- `gx-xl-0` through `gx-xl-5` - Horizontal gap spacing on extra large screens and up
- `gy-xl-0` through `gy-xl-5` - Vertical gap spacing on extra large screens and up

##### Extra Extra Large (xxl)
- `g-xxl-0` through `g-xxl-5` - Gap spacing on extra extra large screens and up
- `gx-xxl-0` through `gx-xxl-5` - Horizontal gap spacing on extra extra large screens and up
- `gy-xxl-0` through `gy-xxl-5` - Vertical gap spacing on extra extra large screens and up
