<?php

namespace Drupal\bootstrap_five_layouts_css_loader\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Bootstrap CSS Loader settings.
 */
class BootstrapCssLoaderSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['bootstrap_five_layouts_css_loader.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bootstrap_five_layouts_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('bootstrap_five_layouts_css_loader.settings');

    $form['load'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Loading Method'),
    ];
    $form['load']['load_method'] = [
      '#type' => 'radios',
      '#title' => $this->t('Choose how to attach the CSS to pages.'),
      '#options' => [
        'page_attachments' => $this->t('Page Attachments'),
        'preprocess_page' => $this->t('Page Preprocess'),
        'preprocess_html' => $this->t('HTML Preprocess'),
        'layout_detection' => $this->t('BS5 Active Layout'),
      ],
      '#default_value' => $config->get('load_method') ?: 'page_attachments',
    ];
    $form['load']['load_method']['page_attachments']['#description'] = $this->t('Recommended.  Consistantly load CSS across page rendering.');
    $form['load']['load_method']['layout_detection']['#description'] = $this->t('Load based on layout usage itself');
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('bootstrap_five_layouts_css_loader.settings')
      ->set('load_method', $form_state->getValue('load_method'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
