(function (Drupal) {
  'use strict';

  function wireResult(inputId, resultId) {
    var input = document.getElementById(inputId);
    var result = document.getElementById(resultId);
    if (!input || !result) {
      return;
    }

    function update() {
      result.textContent = input.value || '(empty)';
    }

    input.addEventListener('change', update);
    update();
  }

  Drupal.behaviors.bsflTestHiddenInputReports = {
    attach: function (context) {
      if (!context.querySelector) {
        return;
      }
      // Only run once per context.
      if (context.__bsflReportsProcessed) {
        return;
      }
      context.__bsflReportsProcessed = true;

      wireResult('test-input-1', 'result-1');
      wireResult('test-input-2', 'result-2');
      wireResult('test-input-3', 'result-3');
      wireResult('test-input-4', 'result-4');
    }
  };
})(Drupal);


