<?php

namespace Drupal\bootstrap_five_layouts_multiselect_test\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Pills Test Form for testing pillbox functionality.
 */
class PillsTestForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bootstrap_five_layouts_pills_test_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Attach necessary libraries.
    $form['#attached'] = [
      'library' => [
        'bootstrap_five_layouts/pillbox',
        'bootstrap_five_layouts/pillbox_counter',
        'bootstrap_five_layouts_multiselect_test/test_reports',
      ],
    ];
    // Preserve nested values for containers like test1/input.
    $form['#tree'] = TRUE;

    // Get submitted values to populate form inputs
    // Use getValues() to access submitted form values during rebuild.
    $submitted_values = $form_state->getUserInput();

    /** @var \Drupal\bootstrap_five_layouts\BootstrapFiveLayoutsManager $manager */
    $manager = \Drupal::service('bootstrap_five_layouts.manager');
    $classlist_map = $manager->getAllKnownClassnames();
    // Expose classlist map to JS via drupalSettings.
    $form['#attached']['drupalSettings']['bootstrap_five_layouts']['classlist_map'] = $classlist_map;

    // Test 1: Basic Pill Box Functionality.
    $form['test1'] = [
      '#type' => 'container',
      '#attributes' => ['class' => ['test-section']],
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h2',
        '#value' => $this->t('Test 1: Basic Pill Box Functionality'),
      ],
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => $this->t('This test creates a basic pill box that converts space-separated text into pills. Try typing classes like "col-6 col-md-4 mb-3" and press Enter or Space.'),
        '#attributes' => ['class' => ['test-description']],
      ],
      'input' => [
        '#type' => 'textfield',
        '#title' => $this->t('Basic Pill Box'),
        '#maxlength' => 516,
        '#attributes' => [
          'data-bsfl-pillbox' => TRUE,
          'data-pillbox-counter' => TRUE,
          'placeholder' => $this->t('Enter classes...'),
        ],
        '#default_value' => $submitted_values['test1']['input'] ?? '',
        '#wrapper_attributes' => ['class' => ['test-input']],
      ],
      'result' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => '<strong>' . $this->t('Hidden Input Value:') . '</strong> <span id="result-1"></span>',
        '#attributes' => ['class' => ['result']],
      ],
    ];

    // Test 2: Bootstrap Column Class Detection.
    $form['test2'] = [
      '#type' => 'container',
      '#attributes' => ['class' => ['test-section']],
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h2',
        '#value' => $this->t('Test 2: Bootstrap Column Class Detection'),
      ],
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => $this->t('This test shows how Bootstrap 5 column classes get special styling (blue background). Try entering: "col-6 col-md-4 col-lg-8 row g-3 mb-2"'),
        '#attributes' => ['class' => ['test-description']],
      ],
      'input' => [
        '#type' => 'textfield',
        '#title' => $this->t('Bootstrap Classes'),
        '#maxlength' => 516,
        '#attributes' => [
          'data-bsfl-pillbox' => TRUE,
          'data-pillbox-counter' => TRUE,
          'placeholder' => $this->t('Enter Bootstrap classes...'),
        ],
        '#default_value' => $submitted_values['test2']['input'] ?? 'col-6 col-md-4 col-lg-8',
        '#wrapper_attributes' => ['class' => ['test-input']],
      ],
      'result' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => '<strong>' . $this->t('Hidden Input Value:') . '</strong> <span id="result-2"></span>',
        '#attributes' => ['class' => ['result']],
      ],
    ];

    // Test 3: Allow Duplicates.
    $form['test3'] = [
      '#type' => 'container',
      '#attributes' => ['class' => ['test-section']],
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h2',
        '#value' => $this->t('Test 3: Allow Duplicates'),
      ],
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => $this->t('This test allows duplicate classes. Try entering "col-6 col-6 col-md-4"'),
      ],
      'input' => [
        '#type' => 'textfield',
        '#title' => $this->t('Allow Duplicates'),
        '#maxlength' => 516,
        '#attributes' => [
          'data-bsfl-pillbox' => TRUE,
          'data-bsfl-pillbox-allow-duplicates' => TRUE,
          'data-pillbox-counter' => TRUE,
          'placeholder' => $this->t('Enter classes (duplicates allowed)...'),
        ],
        '#default_value' => $submitted_values['test3']['input'] ?? '',
      ],
      'result' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => '<strong>' . $this->t('Hidden Input Value:') . '</strong> <span id="result-3"></span>',
        '#attributes' => ['class' => ['result']],
      ],
    ];

    // Test 4: Pre-populated Values.
    $form['test4'] = [
      '#type' => 'container',
      '#attributes' => ['class' => ['test-section']],
      'title' => [
        '#type' => 'html_tag',
        '#tag' => 'h2',
        '#value' => $this->t('Test 4: Pre-populated Values'),
      ],
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => $this->t('This test shows a pill box with pre-existing values.'),
        '#attributes' => ['class' => ['test-description']],
      ],
      'input' => [
        '#type' => 'textfield',
        '#title' => $this->t('Pre-populated'),
        '#maxlength' => 516,
        '#attributes' => [
          'data-bsfl-pillbox' => '',
          'data-pillbox-counter' => TRUE,
          'placeholder' => $this->t('Enter classes...'),
        ],
        '#default_value' => $submitted_values['test4']['input'] ?? 'container row col-6 col-md-4 g-3',
      ],
      'result' => [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => '<strong>' . $this->t('Hidden Input Value:') . '</strong> <span id="result-4"></span>',
      ],
    ];

    // Main title.
    $form['title'] = [
      '#type' => 'html_tag',
      '#tag' => 'h1',
      '#value' => $this->t('Bootstrap Five Layouts Pill Box Test'),
      '#weight' => -100,
    ];

    // Submit actions.
    $form['actions'] = [
      '#type' => 'actions',
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_state->setRebuild(TRUE);
  }

}
