<?php

/**
 * @file
 * Preprocessors and helper functions to make theming easier.
 */

use Drupal\Component\Utility\Html;
use Drupal\Component\Utility\Xss;
use Drupal\Core\Template\Attribute;
use Drupal\bootstrap_five_layouts_viewsstyle\BootstrapFiveLayoutsViewsstyle;

/**
 * Prepares variables for views grid templates.
 *
 * Default template: views-bootstrap-grid.html.twig.
 *
 * @param array $vars
 *   An associative array containing:
 *   - view: A ViewExecutable object.
 *   - rows: The raw row data.
 */
function template_preprocess_bootstrap_five_layouts_viewsstyle_grid(array &$vars): void {
  $view = $vars['view'];
  $rows = $vars['rows'];
  $options = $view->style_plugin->options;
  $vars['id'] = BootstrapFiveLayoutsViewsstyle::getUniqueId($view);
  $attributes = new Attribute(['class' => ['grid']]);

  if ($options['grid_class']) {
    $grid_class = explode(' ', $options['grid_class']);
    $grid_classes = array_map([Html::class, 'cleanCssIdentifier'], array_filter($grid_class));
    $attributes->addClass($grid_classes);
  }

  $col_classes = [];
  foreach (BootstrapFiveLayoutsViewsstyle::getBreakpoints() as $breakpoint) {
    if ($options["col_$breakpoint"] == 'none') {
      continue;
    }
    $col_classes[] = $options["col_$breakpoint"];
  }
  foreach ($rows as $id => $row) {
    $row_attributes = new Attribute();
    if ($row_class = $view->style_plugin->getRowClass($id)) {
      $row_attributes->addClass($row_class);
    }
    $row_attributes->addClass($col_classes);
    $vars['rows'][$id] = [
      'content' => $row,
      'attributes' => $row_attributes,
    ];
  }
  // Check if CSS loader should attach Bootstrap CSS when layout detection is enabled.
  if (\Drupal::moduleHandler()->moduleExists('bootstrap_five_layouts_css_loader')) {
    $library = 'bootstrap_five_layouts_css_loader/toolkit';
    if (!isset($vars['#attached']['library'])) {
      $vars['#attached']['library'] = [];
    }
    if (!in_array($library, $vars['#attached']['library'])) {
      $vars['#attached']['library'][] = $library;
    }
  }
  $vars['attributes'] = $attributes;
}
