<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\Core\Plugin\PluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class BootstrapFiveLayoutsHandlerBase.
 */
abstract class BootstrapFiveLayoutsHandlerBase extends PluginBase implements BootstrapFiveLayoutsHandlerInterface {

  /**
   * The dependency injection container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface
   */
  protected $container;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ?ContainerInterface $container = NULL) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    if (!isset($container)) {
      $container = \Drupal::getContainer();
    }
    $this->container = $container;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static($configuration, $plugin_id, $plugin_definition, $container);
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->pluginDefinition['label'] ?? $this->getPluginId();
  }

  /**
   * {@inheritdoc}
   */
  public function loadInstance($entity_id) {
    $layouts = $this->loadInstances([$entity_id]);
    return reset($layouts);
  }

  /**
   * {@inheritdoc}
   */
  public function saveInstance($entity_id, BootstrapFiveLayout $layout) {
    $this->saveInstances([$entity_id => $layout]);
  }

}
