<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts\Updates;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts\BootstrapFiveLayoutsUpdateBase;

/**
 * Bootstrap Five Layouts Update 8401.
 *
 * Upgrade existing Bootstrap Layout instances.
 *
 * @BootstrapFiveLayoutsUpdate(
 *   id = "bootstrap_five_layouts_update_8401",
 *   schema = 8401
 * )
 */
class BootstrapFiveLayoutsUpdate8401 extends BootstrapFiveLayoutsUpdateBase {

  /**
   * {@inheritdoc}
   */
  public function processExistingLayout(BootstrapFiveLayout $layout, array $data = [], $display_messages = TRUE) {
    // Fix any typos and replace hyphens with underscores.
    $id = preg_replace('/\-+/', '_', preg_replace('/^booststrap/', 'bootstrap', $layout->getId()));

    // Immediately return if existing layout identifier doesn't match
    // one of the old "bootstrap_five_layouts" layouts.
    if (!isset($data['bootstrap_five_layouts_update_map'][$id])) {
      return;
    }

    $layout_map = $data['bootstrap_five_layouts_update_map'][$id];

    // Set the new layout identifier.
    $layout->setId($layout_map['id']);

    // Only update the path if it's actually set.
    $path = $layout->getPath();
    if (isset($path)) {
      $layout->setPath($this->getPath() . '/templates/3.0.0');
    }

    // Set default row wrapper, attributes and classes.
    $layout->setSetting('row.wrapper', 'div');
    $layout->setSetting('row.classes', ['row', 'clearfix']);
    $layout->setSetting('row.attributes', '');

    // Rename existing region and set region wrapper, attributes and classes.
    foreach ($layout_map['regions'] as $old_region => $new_region) {
      if ($old_region !== $new_region && ($region_data = $layout->getRegion($old_region))) {
        $layout->setRegion($new_region, $region_data);
        $layout->unsetRegion($old_region);
      }
      $layout->setSetting("regions.$new_region.wrapper", 'div');
      $layout->setSetting("regions.$new_region.classes", $layout_map['classes'][$new_region]);
      $layout->setSetting("regions.$new_region.attributes", '');
    }
  }

}
