<?php

namespace Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts\Updates;

use Drupal\bootstrap_five_layouts\BootstrapFiveLayout;
use Drupal\bootstrap_five_layouts\Plugin\BootstrapFiveLayouts\BootstrapFiveLayoutsUpdateBase;

/**
 * Bootstrap Five Layouts Update 8402.
 *
 * Fix "1 Column (stacked)" regions.
 *
 * @BootstrapFiveLayoutsUpdate(
 *   id = "bootstrap_five_layouts_update_8402",
 *   schema = 8402
 * )
 */
class BootstrapFiveLayoutsUpdate8402 extends BootstrapFiveLayoutsUpdateBase {

  /**
   * {@inheritdoc}
   */
  public function processExistingLayout(BootstrapFiveLayout $layout, array $data = [], $display_messages = TRUE) {
    if ($layout->getId() !== 'bs_1col_stacked') {
      return;
    }

    $regions = [
      'header' => 'top',
      'footer' => 'bottom',
    ];
    foreach ($regions as $old_region => $new_region) {
      if ($region = $layout->getRegion($old_region)) {
        $layout->setRegion($new_region, $region);
        $layout->unsetRegion($old_region);
      }
    }
  }

}
