/**
 * @file
 * JS for video form.
 */

(function ($) {
  Drupal.behaviors.brightcoveChosen = {
    attach: (context) => {
      const submitButtons = $('input[type="submit"]');
      let isFileField = false;

      $('input[type="file"]').mousedown(function () {
        isFileField = true;
      });

      // Disable buttons while the uploading is running.
      // eslint-disable-next-line no-jquery/no-ajax-events
      $(context).on('ajaxStart', () => {
        if (isFileField) {
          submitButtons.prop('disabled', true);
        }
      });

      // Enable buttons after the upload is finished.
      // eslint-disable-next-line no-jquery/no-ajax-events
      $(context).on('ajaxStop', () => {
        if (isFileField) {
          submitButtons.prop('disabled', false);
          isFileField = false;
        }
      });
    },
  };
})(jQuery);
