<?php

declare(strict_types=1);

namespace Drupal\media_brightcove\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * A media test constraint.
 */
#[Constraint(
  id: 'BrightcoveVideoConstraint',
  label: new TranslatableMarkup('Media constraint for Brightcove Videos.', options: ['context' => 'Validation']),
  type: [
    'entity',
    'entity_reference',
  ],
)]
class VideoConstraint extends SymfonyConstraint {

  /**
   * The default violation message.
   */
  public string $message = 'Inappropriate field settings.';

}
