<?php

declare(strict_types=1);

namespace Drupal\media_brightcove\Plugin\Validation\Constraint;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the video constraint.
 */
class VideoConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate($value, Constraint $constraint): void {
    assert($constraint instanceof VideoConstraint);

    if (!($value instanceof EntityReferenceFieldItemList)) {
      $this->context->addViolation($constraint->message);
    }
    /** @var \Drupal\Core\Field\EntityReferenceFieldItemList $value */
    $target_type = $value->getFieldDefinition()
      ->getFieldStorageDefinition()
      ->getSetting('target_type');

    if ($target_type !== 'brightcove_video') {
      $this->context->addViolation($constraint->message);
    }
  }

}
