<?php

declare(strict_types=1);

namespace Drupal\brightcove\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the Brightcove Text Track entity.
 *
 * @see \Drupal\brightcove\Entity\BrightcoveTextTrack.
 */
class TextTrackAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account): AccessResultInterface {
    /** @var \Drupal\brightcove\Entity\TextTrackInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished brightcove text track entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published brightcove text track entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete brightcove text track entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL): AccessResultInterface {
    return AccessResult::allowedIfHasPermission($account, 'add brightcove text track entities');
  }

}
