<?php

declare(strict_types=1);

namespace Drupal\brightcove\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the Brightcove Video.
 *
 * @see \Drupal\brightcove\Entity\BrightcoveVideo.
 */
class VideoAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account): AccessResultInterface {
    /** @var \Drupal\brightcove\Entity\VideoInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished brightcove videos');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published brightcove videos');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit brightcove videos');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete brightcove videos');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL): AccessResultInterface {
    return AccessResult::allowedIfHasPermission($account, 'add brightcove videos');
  }

}
