<?php

declare(strict_types=1);

namespace Drupal\brightcove\Entity;

use Drupal\views\EntityViewsData;
use Drupal\views\EntityViewsDataInterface;

/**
 * Provides Views data for Brightcove Text Track entities.
 */
class TextTrackViewsData extends EntityViewsData implements EntityViewsDataInterface {

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    $data = parent::getViewsData();

    $data['brightcove_text_track']['table']['base'] = [
      'field' => 'id',
      'title' => $this->t('Brightcove Text Track'),
      'help' => $this->t('Brightcove Text Track ID.'),
    ];

    return $data;
  }

}
