<?php

declare(strict_types=1);

namespace Drupal\brightcove\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event for HTTP client config.
 */
final class HttpClientConfigEvent extends Event {

  /**
   * List of config items.
   */
  private array $items = [];

  /**
   * Returns all config items.
   *
   * @return array
   *   List of config items.
   */
  public function getAll(): array {
    return $this->items;
  }

  /**
   * Sets a config item.
   *
   * @param string $name
   *   Name of the config.
   * @param mixed $value
   *   Value of the config.
   */
  public function set(string $name, mixed $value): void {
    $this->items[$name] = $value;
  }

}
